<?php
	class st_hybrid_contactus extends WP_Widget{
	
		function st_hybrid_contactus() 
		{
			parent::WP_Widget(false, $name = 'Hybrid > Contact Us');
		}
		
		function widget($args, $instance)
		{
			extract( $args );
			$title = apply_filters('widget_title', $instance['title']);			
			if ( !(is_page_template('template-blog.php') || is_home() || is_single())) {
					echo '<div class="span3">';// Display some text
			}
			  ?>			 			 
					 	<h3><?php echo $title ; ?></h3>
						 <div class="widget" id="">
						 	<div class="contact-info">
						 		<div class="elem">
						 			<i class="<?php the_field('address_icon','options');?>"></i>
						 		</div>
						 		<div class="elem">
						 			<p class="post-categoty capitalize color-black"><?php the_field('address_title','options'); ?></p>
						 			<p><?php the_field('address_description','options');?></p>
						 		</div>
						 	</div>
							<div class="contact-info">
						 		<div class="elem">
						 			<i class="<?php the_field('phone_icon','options');?>"></i>
						 		</div>
						 		<div class="elem">
						 			<p class="post-categoty capitalize color-black"><?php the_field('phone_title','options'); ?></p>
						 			<p><?php the_field('phone_number','options');?></p>
						 		</div>
						 	</div>
							<div class="contact-info">
						 		<div class="elem">
						 			<i class="<?php the_field('email_icon','options');?>"></i>
						 		</div>
						 		<div class="elem">
						 			<p class="post-categoty capitalize color-black"><?php the_field('email_title','options'); ?></p>
						 			<p><?php the_field('email_address','options');?></p>
						 		</div>
						 	</div>
						 </div>			
						
		<?php		
				if ( !(is_page_template('template-blog.php') || is_home() || is_single())) {
					echo '</div>';
					}	
         
		}
		
		function update($new_instance, $old_instance)
		{
			$instance = $old_instance;
			$instance['title'] = strip_tags($new_instance['title']);
			return $instance;
		}
		
		function form($instance)
		{
			$title = isset($instance['title']) ? esc_attr($instance['title']) : "";			
			?>
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Widget Title',"hybrid_lang"); ?></label>
				<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
			</p>
			<?php
		}
	}
	
	function st_hybrid_widgets_contactus() {			
		register_widget('st_hybrid_contactus');			
	}
	add_action('widgets_init', 'st_hybrid_widgets_contactus');
?>